function [scores] = compute_score(model,data1,data2)
%UNTITLED5 Summary of this function goes here
%   Detailed explanation goes here
 
        data1 = data1 - model.mu;
        data2 = data2 - model.mu;

       % compute log-likelihood ratios
        sigma_wc = model.invW;
        sigma_ac = model.invB;
        sigma_tot = sigma_wc + sigma_ac;
        h1 = -inv(sigma_wc + 2 * sigma_ac);
        h2 = inv(sigma_wc);
        lamb_tot = h1 + h2;
        gamma = h1 - h2 + 2 * inv(sigma_tot);
        
        gamma11 = sum((data1*gamma).*data1,2);
        gamma22 = sum((data2*gamma).*data2,2);
        scores = 2 * ((data1*lamb_tot)* transpose(data2)) + gamma11(:, 1) + gamma22;

%         # Compute log-determinant of the Sigma_tot matrix (first line)
%         # E, junk = np.linalg.eig(Sigma_tot)
%         # log_det_first = np.sum(np.log(E))
        log_det_first = log(abs(det(sigma_tot)));

%         # Compute log-determinant of the second-line matrix
%         # E, junk = np.linalg.eig(Sigma_wc + 2 * Sigma_ac)
%         # log_det_second = np.sum(np.log(E))
        log_det_second = log(abs(det(sigma_wc + 2 * sigma_ac)));

%         # Compute log-determinant of the third-line matrix
%         # E, junk = np.linalg.eig(Sigma_wc)
%         # log_det_third = np.sum(np.log(E))
        log_det_third = log(abs(det(sigma_wc)));

%         # Put it all together
%         # XXX PW: What is this for?
        k = log_det_first - 0.5 * log_det_second - 0.5 * log_det_third;

        %scores += k
%         # PW Account for single questioned- or known-speaker embedding (for Evaluation module).
        if size(scores,1) > 1
            scores = diag(scores);
        else
            scores = scores;
        end
end

